unit Sensor03;
// ====================================================================
(*
       
      ().
           
       (TPanel)   .
   // -----------------------------------------------------
   //     :
   //    XBeg          X -   Image
   //    YBeg          Y -   Image
   //    Title          
   //    Min            
   //    Max            
   //    Indx              
   // -----------------------------------------------------
   //   :
   Sensor := TSensor.Create( Panel1,   //      
                             XB, YB);  // Left  Top  
   // -----------------------------------------------------
   //       :
   if Assigned(Sensor)
   then ...... := Sensor.Value;       //   
   // -----------------------------------------------------
    3.5. ()  , , , 2017..2020 .
               () Source code  ..
     27.12.2019
*)
// ====================================================================
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls;

// ================================================================
//    
type TOnSensor = procedure(Sender : TObject) of object;

// ================================================================
//      ()
type TSensor = class(TObject)
private
  // ---------------
  fPanel      : TPanel;       //    
  fColor      : TColor;       //  
  // ---------------
  fLbIndx     : TLabel;       //   
  fLbTitle    : TLabel;       //   
  fSTxtIndx   : TStaticText;  //  
  fEdTitle    : TEdit;        //  
  // ---------------
  fLbMin      : TLabel;       //    
  fLbValue    : TLabel;       //    
  fLbMax      : TLabel;       //    
  fEdMin      : TEdit;        //   
  fSTxtValue  : TStaticText;  //   
  fEdMax      : TEdit;        //   
  // ---------------
  fTrackBar   : TTrackBar;    //   
  // ---------------
  fOnSensor   : TOnSensor;    //  -    
  fLinkInd1   : integer;      //     1
  fLinkInd2   : integer;      //     2
  fLinkOBJ    : TObject;      //    
  // ---------------
  fRqNoise    : boolean;      //   
  fChBoxNoise : TCheckBox;    //   
  fNoise      : integer;      //   
  fEdNoise    : TEdit;        //   
  // ---------------
  fValue      : extended;     //    
  // ---------------
  fCVisible   : boolean;      //  fTrackBar, fEdMin, fEdMax
  fNVisible   : boolean;      //  fChBoxNoise, fEdNoise
  // ---------------
  //    
  //    
  procedure RunOnChangeSensor();
  //   
  procedure EdMinChange(Sender: TObject);
  procedure EdMaxChange(Sender: TObject);
  procedure TrackBarChange(Sender: TObject);
  procedure ChBoxNoiseChange(Sender: TObject);
  procedure EdNoiseChange(Sender: TObject);
  // ---------------------
  //  
  // ---------------------
  procedure SetIndx(Indx : integer);
  function  GetIndx() : integer;
   // ---------------------
  procedure SetTitle(Title : string);
  function  GetTitle() : string;
  // ---------------------
  procedure SetMin(Min : integer);
  function  GetMin() : integer;
  // ---------------------
  procedure SetMax(Max : integer);
  function  GetMax() : integer;
  // ---------------------
  procedure SetRqNoise(RqNoice : boolean);
  function  GetRqNoise() : boolean;
  // ---------------------
  procedure SetNoise(Noise : integer);
  function  GetNoise() : integer;
  // ---------------------
  // /  
  procedure SetValue(Value : extended);
  function  GetValue() : extended;
  // ---------------------
  //   
  procedure SetColor(RqColor : TColor);
  // ---------------------
  //    fTrackBar, fEdMin, fEdMax
  procedure SetCVisible(RqCVisible : boolean);
  //    
  procedure SetNVisible(RqNVisible : boolean);
  // ---------------------
public
  constructor Create(RqWinControl : TWinControl; XB,YB : integer);
  procedure Free;
  // ----------------------
  property Indx    : integer  read GetIndx    write SetIndx;
  property Title   : string   read GetTitle   write SetTitle;
  property Min     : integer  read GetMin     write SetMin;
  property Max     : integer  read GetMax     write SetMax;
  property RqNoise : boolean  read GetRqNoise write SetRqNoise;
  property Noise   : integer  read GetNoise   write SetNoise;
  property Value   : extended read GetValue   write SetValue;
  // ----------------------
  //  -    
  property OnSensor : TOnSensor read fOnSensor    write fOnSensor;
  //     1
  property LinkInd1 : integer   read fLinkInd1    write fLinkInd1;
  //     2
  property LinkInd2 : integer   read fLinkInd2    write fLinkInd2;
  //    
  property LinkOBJ  : TObject   read fLinkOBJ     write fLinkOBJ;
  // ----------------------
  //   
  property Color : TColor       read fColor       write SetColor;
  //    fTrackBar, fEdMin, fEdMax
  property CVisible   : boolean  read fCVisible   write SetCVisible;
  //     fChBoxNoise, fEdNoise
  property NVisible   : boolean  read fNVisible   write SetNVisible;
end;

// ================================================================
// ================================================================

implementation

// ================================================================
// ================================================================

// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
//  RqEdit.Text     
function TryEditToInt(RqEdit : TEdit; var Value : integer) : boolean;
begin
   Result := False;
   try
       if Trim(RqEdit.Text) = ''
       then Value := 0
       else begin
           Value := StrToInt(Trim(RqEdit.Text));
           RqEdit.Color := clWindow;
       end;
       Result := True;
   except
       RqEdit.Color := RGB(255,200,200);
       ShowMessage('       ');
   end;
end;

// ----------------------------------------------------------------
//   ,   TControl.
//  CreateControl    class () 
// ,      RqOwner
// (,  Form1).

function CreateControl(ControlClass  : TControlClass;
                       RqOwner       : TWinControl;
                 const ComponentName : string;
                      X, Y, W, H     : Integer): TControl;
begin
    Result := ControlClass.Create(RqOwner);
    with Result do
    begin
      Parent := RqOwner;               //    
      Name := ComponentName;           //   
      SetBounds(X, Y, W, H);           //   TWinControl
      Visible := True;                 //   
    end;
end;

// ================================================================
//    / 
// ================================================================
// ----------------------------------------------------------------
//   
constructor TSensor.Create(
          RqWinControl : TWinControl;  //      
          XB, YB : integer);           // Left  Top  
begin
   inherited Create;
   // ----------------------------------------------
   //      
   fPanel:= TPanel(CreateControl(TPanel, RqWinControl, '',
                   XB,YB,180,132));
   fPanel.BevelWidth := 3;
   fColor := clBtnFace;
   fPanel.Color := fColor;
   // ----------------------------------------------
   //       
   // ----------------------------------------------
   //  
   fLbIndx := TLabel(CreateControl(TLabel, fPanel, '',
                       12,8,26,16));
   fLbIndx.AutoSize := False;
   fLbIndx.Caption  := 'Indx';
   fSTxtIndx := TStaticText(CreateControl(TStaticText, fPanel, '',
                       12, 24, 26, 17));
   fSTxtIndx.Alignment   := taCenter;
   fSTxtIndx.AutoSize    := False;
   fSTxtIndx.BorderStyle := sbsSunken;
   fSTxtIndx.Font.Style  := [fsBold];
   fSTxtIndx.Enabled := False;
   // ----------------------------------------------
   //  
   fLbTitle := TLabel(CreateControl(TLabel, fPanel, '',
                       42,8,100,16));
   fLbTitle.AutoSize := False;
   fLbTitle.Caption  := ' ';
   fEdTitle := TEdit(CreateControl(TEdit, fPanel, '',
                       42, 24, 128, 18));
   fEdTitle.AutoSize := False;
   fEdTitle.Enabled := False;
   // ----------------------------------------------
   //  
   fEdMin  := TEdit(CreateControl(TEdit, fPanel, '',
                       12,60,50,18));
   fEdMin.AutoSize := False;
   fEdMin.Text := '-10';
   fEdMin.OnChange := EdMinChange;
   fLbMin := TLabel(CreateControl(TLabel, fPanel, '',
                       12,44,50,16));
   fLbMin.AutoSize := False;
   fLbMin.Caption := 'Min';
   // ----------------------------------------------
   //  
   fSTxtValue := TStaticText(CreateControl(TStaticText, fPanel, '',
                        66,60,50,18));
   fSTxtValue.Alignment   := taCenter;
   fSTxtValue.AutoSize    := False;
   fSTxtValue.BorderStyle := sbsSunken;
   fSTxtValue.Font.Style  := [fsBold];
   fSTxtValue.Caption := '0';
   fLbValue := TLabel(CreateControl(TLabel, fPanel, '',
                       66,44,50,16));
   fLbValue.AutoSize := False;
   fLbValue.Caption  := 'Value';
   // ----------------------------------------------
   //  
   fEdMax := TEdit(CreateControl(TEdit, fPanel, '',
                       120,60,50,18));
   fEdMax.AutoSize := False;
   fEdMax.Text := '10';
   fEdMax.OnChange := EdMaxChange;
   fLbMax := TLabel(CreateControl(TLabel, fPanel, '',
                       120,44,50,16));
   fLbMax.AutoSize := False;
   fLbMax.Caption  := 'Max';
   // ----------------------------------------------
   //  
   fTrackBar := TTrackBar(CreateControl(TTrackBar, fPanel, '',
                           5, 84, 170, 22));
   fTrackBar.TickStyle := tsNone;
   fTrackBar.ThumbLength := 16;
   fTrackBar.TickMarks := tmTopLeft;
   fTrackBar.Min := -10;
   fTrackBar.Max :=  10;
   fTrackBar.Position := 0;
   fTrackBar.OnChange := TrackBarChange;
   // ----------------------------------------------
   fValue := 0;
   // ----------------------------------------------
   //   
   fChBoxNoise := TCheckBox(CreateControl(TCheckBox, fPanel, '',
                           12, 108, 100, 20));
   fRqNoise := False;
   fChBoxNoise.Checked := fRqNoise;
   fChBoxNoise.Caption := ' +   Amp :';
   fChBoxNoise.OnClick := ChBoxNoiseChange;
   // ----------------------------------------------
   //  
   fEdNoise := TEdit(CreateControl(TEdit, fPanel, '',
                           119,108,50,18));
   fEdNoise.AutoSize := False;
   fEdNoise.Text := '2';
   fEdNoise.OnChange := EdNoiseChange;
   // ----------------------------------------------
   //    fTrackBar, fEdMin, fEdMax
   SetCVisible(True);
   // ----------------------------------------------
   //    
   Randomize;
end;
// ----------------------------------------------------------------
//   
procedure TSensor.Free;
begin
  // ---------------
  fLbIndx.Free;
  fLbTitle.Free;
  fSTxtIndx.Free;
  fEdTitle.Free;
  // ---------------
  fLbMin.Free;
  fLbValue.Free;
  fLbMax.Free;
  fEdMin.Free;
  fSTxtValue.Free;
  fEdMax.Free;
  // ---------------
  fTrackBar.Free;
  // ---------------
  fChBoxNoise.Free;
  fEdNoise.Free;
  // ---------------
  fPanel.Free;
  // ---------------
  inherited Free;
end;

// ================================================================
//       
// ================================================================
//      
procedure TSensor.RunOnChangeSensor();
begin
  if Assigned(fOnSensor)
  then begin
     try fOnSensor(Self);
     except end;
  end;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.EdMinChange(Sender: TObject);
var Value : integer;
begin
  if TryEditToInt(fEdMin, Value)
  then begin
    fTrackBar.Min := Value;
    fTrackBar.Position := fTrackBar.Min
                        + (fTrackBar.Max - fTrackBar.Min) div 2;
    fSTxtValue.Caption := IntToStr(fTrackBar.Position);
    RunOnChangeSensor();
  end;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.EdMaxChange(Sender: TObject);
var Value : integer;
begin
  if TryEditToInt(fEdMax, Value)
  then begin
     fTrackBar.Max := Value;
     fTrackBar.Position := fTrackBar.Min
                        + (fTrackBar.Max - fTrackBar.Min) div 2;
     fSTxtValue.Caption := IntToStr(fTrackBar.Position);
     RunOnChangeSensor();
  end;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.TrackBarChange(Sender: TObject);
begin
  fValue := fTrackBar.Position;
  fSTxtValue.Caption := IntToStr(fTrackBar.Position);
  RunOnChangeSensor();
end;
// ----------------------------------------------------------------
procedure TSensor.ChBoxNoiseChange(Sender: TObject);
begin
  fRqNoise := fChBoxNoise.Checked;
  RunOnChangeSensor();
end;
// ----------------------------------------------------------------
procedure TSensor.EdNoiseChange(Sender: TObject);
var Value : integer;
begin
  if TryEditToInt(fEdNoise, Value)
  then begin
     fNoise := Value;
     RunOnChangeSensor();
  end;   
end;

// ================================================================
//    
// ================================================================
// ----------------------------------------------------------------
//    (    )
procedure TSensor.SetIndx(Indx : integer);
begin
  fSTxtIndx.Tag := Indx;
  fSTxtIndx.Caption := IntToStr(Indx);
end;
// ----------------------------------------------------------------
//    (    )
function TSensor.GetIndx() : integer;
begin
  Result := fSTxtIndx.Tag;
end;
// ----------------------------------------------------------------
//   
procedure TSensor.SetTitle(Title : string);
begin
  fEdTitle.Text := Title;
end;
// ----------------------------------------------------------------
//   
function TSensor.GetTitle() : string;
begin
   Result := fEdTitle.Text;
end;
// ----------------------------------------------------------------
// ----------------------------------------------------------------
//    
procedure TSensor.SetMin(Min : integer);
begin
  if Min < fTrackBar.Max
  then begin
     // -----------------------
     //    
     fEdMin.Enabled    := False;
     fTrackBar.Enabled := False;
     // -----------------------
     fEdMin.Text := IntToStr(Min);
     fTrackBar.Min := Min;
     fTrackBar.Position := fTrackBar.Min
                         + (fTrackBar.Max - fTrackBar.Min) div 2;
     fSTxtValue.Caption := IntToStr(fTrackBar.Position);
     // -----------------------
     //    
     fTrackBar.Enabled := True;
     fEdMin.Enabled    := True;
     // -----------------------
     //    
     RunOnChangeSensor();
  end;
end;
// ----------------------------------------------------------------
//    
function  TSensor.GetMin() : integer;
begin
   Result := fTrackBar.Min;
end;
// ----------------------------------------------------------------
// ----------------------------------------------------------------
//    
procedure TSensor.SetMax(Max : integer);
begin
  if Max > fTrackBar.Min
  then begin
     // -----------------------
     //    
     fEdMax.Enabled    := False;
     fTrackBar.Enabled := False;
     // -----------------------
     fEdMax.Text   := IntToStr(Max);
     fTrackBar.Max := Max;
     fTrackBar.Position := fTrackBar.Min
                         + (fTrackBar.Max - fTrackBar.Min) div 2;
     fSTxtValue.Caption := IntToStr(fTrackBar.Position);
     // -----------------------
     //    
     fTrackBar.Enabled := True;
     fEdMax.Enabled    := True;
     // -----------------------
     //    
     RunOnChangeSensor();
  end;
end;
// ----------------------------------------------------------------
//    
function  TSensor.GetMax() : integer;
begin
   Result := fTrackBar.Max;
end;
// ----------------------------------------------------------------
// ----------------------------------------------------------------
//     
procedure TSensor.SetRqNoise(RqNoice : boolean);
begin
     // -----------------------
     //    
     fChBoxNoise.Enabled := False;
     // -----------------------
     fRqNoise := RqNoice;
     fChBoxNoise.Checked := fRqNoise;
     // -----------------------
     //    
     fChBoxNoise.Enabled := True;
     // -----------------------
     //    
     RunOnChangeSensor();
end;
// ----------------------------------------------------------------
//     
function TSensor.GetRqNoise() : boolean;
begin
    Result := fRqNoise;
end;
// ----------------------------------------------------------------
// ----------------------------------------------------------------
//   
procedure TSensor.SetNoise(Noise : integer);
var wAmp : integer;
begin
     wAmp := fTrackBar.Max - fTrackBar.Min;
     if Abs(Noise) > Abs(wAmp) then Exit;
     // -----------------------
     //    
     fEdNoise.Enabled := False;
     // -----------------------
     fEdNoise.Text := IntToStr(Noise);
     fNoise := Noise;
     // -----------------------
     //    
     fEdNoise.Enabled := True;
     // -----------------------
     //    
     RunOnChangeSensor();
end;
// ----------------------------------------------------------------
//   
function TSensor.GetNoise() : integer;
begin
    Result := fNoise;
end;
// ----------------------------------------------------------------
// ----------------------------------------------------------------
//     
procedure TSensor.SetValue(Value : extended);
begin
     if (Value < fTrackBar.Min) or (Value > fTrackBar.Max)
     then Exit;
     // -----------------------
     //    
     fTrackBar.Enabled := False;
     // -----------------------
     fValue := Value;
     fSTxtValue.Caption := IntToStr(Round(fValue));
     fTrackBar.Position := Round(fValue);
     // -----------------------
     //    
     fTrackBar.Enabled := True;
     // -----------------------
     //    
     RunOnChangeSensor();
end;
// ----------------------------------------------------------------
//    
function  TSensor.GetValue() : extended;
begin
   Result := fValue;
end;
// ----------------------------------------------------------------
// ----------------------------------------------------------------
//   
procedure TSensor.SetColor(RqColor : TColor);
begin
    fColor := RqColor;
    fPanel.Color := fColor;
end;
// ----------------------------------------------------------------
//    fTrackBar, fEdMin, fEdMax
procedure TSensor.SetCVisible(RqCVisible : boolean);
begin
   fTrackBar.Enabled := RqCVisible;
   fTrackBar.Visible := RqCVisible;
   fEdMin.Visible := RqCVisible;
   fEdMax.Visible := RqCVisible;
   fLbMin.Visible := RqCVisible;
   fLbMax.Visible := RqCVisible;
   fCVisible := RqCVisible;
end;
// ----------------------------------------------------------------
//     fChBoxNoise, fEdNoise
procedure TSensor.SetNVisible(RqNVisible : boolean);
begin
   fChBoxNoise.Enabled := RqNVisible;
   fEdNoise.Visible := RqNVisible;
   fNVisible := RqNVisible;
end;

// ================================================================
//   
// ================================================================
end.

